<?php
/*
Template Name: 採用情報
*/
?>
<?php get_header(); ?>
<div class="page-container page-recruit page-templates">
    <!-- page-head -->
    <?php get_template_part('template-parts/page-head'); ?>
    <!-- /page-head -->

    <!-- contents -->
    <div class="post inner">
        <h2 class="wp-block-heading">募集要項</h2>
        <div class="wp-block-group inner-sh is-layout-constrained">
            <div class="wp-block-group__inner-container">
                <p class="tac mb40">ウィズ春日井柏原では以下の職種を募集しています。</p>
                <div class="wp-block-group qa-wrap is-layout-constrained">
                    <div class="wp-block-group__inner-container">
                        <div class="wp-block-group question is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <div class="toggle-icon">
                                    <span class="plus"></span>
                                    <span class="minus"></span>
                                </div>
                                <p>相談支援専門員（正社員）</p>
                            </div>
                        </div>
                        <div class="wp-block-group answer is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <figure class="wp-block-table">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>募集内容</td>
                                                <td>相談支援専門員（正社員）</td>
                                            </tr>
                                            <tr>
                                                <td>仕事内容</td>
                                                <td>サービス等利用計画の作成・計画相談アセスメント・モニタリング</td>
                                            </tr>
                                            <tr>
                                                <td>診療科目<br>サービス形態</td>
                                                <td>障がい者支援・一般相談支援・特定相談金額・障害児相談支援<br>計画相談支援・地域定着支援</td>
                                            </tr>
                                            <tr>
                                                <td>給与</td>
                                                <td>【正職員】月給180,000円～230,000円</td>
                                            </tr>
                                            <tr>
                                                <td>給与の備考</td>
                                                <td>基本給：180,000円<br>資格手当（相談支援専門員）: 25,000円<br>実務手当（相談支援専門員）: 25,000円<br>残業手当</td>
                                            </tr>
                                            <tr>
                                                <td>待遇</td>
                                                <td>社会保険完備・ボーナス、賞与有・交通費支給</td>
                                            </tr>
                                            <tr>
                                                <td>勤務時間</td>
                                                <td>9：00～18：00（休憩60分）　勤務時間は相談可<br>残業ほぼ無し</td>
                                            </tr>
                                            <tr>
                                                <td>休日</td>
                                                <td>週休2日<br>土曜・日曜・祝日は休日</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="wp-block-group qa-wrap is-layout-constrained">
                    <div class="wp-block-group__inner-container">
                        <div class="wp-block-group question is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <div class="toggle-icon">
                                    <span class="plus"></span>
                                    <span class="minus"></span>
                                </div>
                                <p>相談支援専門員（パート）</p>
                            </div>
                        </div>
                        <div class="wp-block-group answer is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <figure class="wp-block-table">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>募集内容</td>
                                                <td>相談支援専門員（パート）</td>
                                            </tr>
                                            <tr>
                                                <td>仕事内容</td>
                                                <td>サービス等利用計画の作成・計画相談アセスメント・モニタリング</td>
                                            </tr>
                                            <tr>
                                                <td>診療科目<br>サービス形態</td>
                                                <td>障がい者支援・一般相談支援・特定相談金額・障害児相談支援<br>計画相談支援・地域定着支援</td>
                                            </tr>
                                            <tr>
                                                <td>給与</td>
                                                <td>【パート】時給1,200円～1,500円</td>
                                            </tr>
                                            <tr>
                                                <td>給与の備考</td>
                                                <td>基本給：1,200円<br>相談支援専門員資格・実務によって変動あり</td>
                                            </tr>
                                            <tr>
                                                <td>待遇</td>
                                                <td>社会保険完備・ボーナス、賞与有・交通費支給</td>
                                            </tr>
                                            <tr>
                                                <td>勤務時間</td>
                                                <td>9：00～18：00（休憩60分）　勤務時間は相談可<br>残業ほぼ無し</td>
                                            </tr>
                                            <tr>
                                                <td>休日</td>
                                                <td>週休2日<br>土曜・日曜・祝日は休日</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="wp-block-group qa-wrap is-layout-constrained">
                    <div class="wp-block-group__inner-container">
                        <div class="wp-block-group question is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <div class="toggle-icon">
                                    <span class="plus"></span>
                                    <span class="minus"></span>
                                </div>
                                <p>児童指導員（正社員）</p>
                            </div>
                        </div>
                        <div class="wp-block-group answer is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <figure class="wp-block-table">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>募集内容</td>
                                                <td>児童指導員（正社員）</td>
                                            </tr>
                                            <tr>
                                                <td>仕事内容</td>
                                                <td>個別支援計画・モニタリング・企画作成・送迎・児童指導員業務全般</td>
                                            </tr>
                                            <tr>
                                                <td>診療科目<br>サービス形態</td>
                                                <td>放課後等デイサービス・児童発達支援</td>
                                            </tr>
                                            <tr>
                                                <td>給与</td>
                                                <td>【正職員】月給210,000円～235,000円</td>
                                            </tr>
                                            <tr>
                                                <td>給与の備考</td>
                                                <td>基本給：180,000円<br>処遇改善手当：20,000円<br>ベースアップ加算手当：10,000円<br>資格手当：資格によって変動あり（例：保育士：10,000円）<br>残業手当</td>
                                            </tr>
                                            <tr>
                                                <td>待遇</td>
                                                <td>社会保険完備・ボーナス、賞与有・交通費支給</td>
                                            </tr>
                                            <tr>
                                                <td>勤務時間</td>
                                                <td>10：00～19：00（休憩60分）　勤務時間は相談可<br>9：30～18：30（休憩60分）　勤務時間は相談可<br>残業ほぼ無し</td>
                                            </tr>
                                            <tr>
                                                <td>休日</td>
                                                <td>週休2日<br>日曜・その他１日</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="wp-block-group qa-wrap is-layout-constrained">
                    <div class="wp-block-group__inner-container">
                        <div class="wp-block-group question is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <div class="toggle-icon">
                                    <span class="plus"></span>
                                    <span class="minus"></span>
                                </div>
                                <p>児童指導員（パート）</p>
                            </div>
                        </div>
                        <div class="wp-block-group answer is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <figure class="wp-block-table">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>募集内容</td>
                                                <td>児童指導員（パート）</td>
                                            </tr>
                                            <tr>
                                                <td>仕事内容</td>
                                                <td>企画作成・送迎・児童指導員業務全般</td>
                                            </tr>
                                            <tr>
                                                <td>診療科目<br>サービス形態</td>
                                                <td>放課後等デイサービス・児童発達支援</td>
                                            </tr>
                                            <tr>
                                                <td>給与</td>
                                                <td>【パート】時給1,150円～1,250円</td>
                                            </tr>
                                            <tr>
                                                <td>給与の備考</td>
                                                <td>基本給：1,050円+処遇改善手当 100円<br>資格・実務経験によって変動あり</td>
                                            </tr>
                                            <tr>
                                                <td>待遇</td>
                                                <td>社会保険完備・ボーナス、賞与有・交通費支給</td>
                                            </tr>
                                            <tr>
                                                <td>勤務時間</td>
                                                <td>10：00～19：00（休憩60分）　勤務時間は相談可<br>12：30～18：30　勤務時間は相談可<br>残業ほぼ無し</td>
                                            </tr>
                                            <tr>
                                                <td>休日</td>
                                                <td>日曜日　シフト制　※週2～週5</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="wp-block-group qa-wrap is-layout-constrained">
                    <div class="wp-block-group__inner-container">
                        <div class="wp-block-group question is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <div class="toggle-icon">
                                    <span class="plus"></span>
                                    <span class="minus"></span>
                                </div>
                                <p>理学療法士（正社員）</p>
                            </div>
                        </div>
                        <div class="wp-block-group answer is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <figure class="wp-block-table">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>募集内容</td>
                                                <td>理学療法士（正社員）</td>
                                            </tr>
                                            <tr>
                                                <td>仕事内容</td>
                                                <td>個別支援計画・モニタリング・企画作成・送迎・児童指導員業務全般</td>
                                            </tr>
                                            <tr>
                                                <td>診療科目<br>サービス形態</td>
                                                <td>放課後等デイサービス・児童発達支援</td>
                                            </tr>
                                            <tr>
                                                <td>給与</td>
                                                <td>【正職員】月給225,000円～250,000円</td>
                                            </tr>
                                            <tr>
                                                <td>給与の備考</td>
                                                <td>基本給：180,000円<br>資格手当（理学療法士）: 15,000円<br>実務手当: 15,000円<br>処遇改善手当：20,000円<br>ベースアップ加算手当：10,000円<br>残業手当</td>
                                            </tr>
                                            <tr>
                                                <td>待遇</td>
                                                <td>社会保険完備・ボーナス、賞与有・交通費支給</td>
                                            </tr>
                                            <tr>
                                                <td>勤務時間</td>
                                                <td>10：00～19：00（休憩60分）　勤務時間は相談可<br>9：30～18：30（休憩60分）　勤務時間は相談可<br>残業ほぼ無し</td>
                                            </tr>
                                            <tr>
                                                <td>休日</td>
                                                <td>週休2日<br>日曜・その他１日</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="wp-block-group qa-wrap is-layout-constrained">
                    <div class="wp-block-group__inner-container">
                        <div class="wp-block-group question is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <div class="toggle-icon">
                                    <span class="plus"></span>
                                    <span class="minus"></span>
                                </div>
                                <p>作業療法士（正社員）</p>
                            </div>
                        </div>
                        <div class="wp-block-group answer is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <figure class="wp-block-table">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>募集内容</td>
                                                <td>作業療法士（正社員）</td>
                                            </tr>
                                            <tr>
                                                <td>仕事内容</td>
                                                <td>個別支援計画・モニタリング・企画作成・送迎・児童指導員業務全般</td>
                                            </tr>
                                            <tr>
                                                <td>診療科目<br>サービス形態</td>
                                                <td>放課後等デイサービス・児童発達支援</td>
                                            </tr>
                                            <tr>
                                                <td>給与</td>
                                                <td>【正職員】月給225,000円～250,000円</td>
                                            </tr>
                                            <tr>
                                                <td>給与の備考</td>
                                                <td>基本給：180,000円<br>資格手当（作業療法士）: 15,000円<br>実務手当: 15,000円<br>処遇改善手当：20,000円<br>ベースアップ加算手当：10,000円<br>残業手当</td>
                                            </tr>
                                            <tr>
                                                <td>待遇</td>
                                                <td>社会保険完備・ボーナス、賞与有・交通費支給</td>
                                            </tr>
                                            <tr>
                                                <td>勤務時間</td>
                                                <td>10：00～19：00（休憩60分）　勤務時間は相談可<br>9：30～18：30（休憩60分）　勤務時間は相談可<br>残業ほぼ無し</td>
                                            </tr>
                                            <tr>
                                                <td>休日</td>
                                                <td>週休2日<br>日曜・その他１日</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="wp-block-group qa-wrap is-layout-constrained">
                    <div class="wp-block-group__inner-container">
                        <div class="wp-block-group question is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <div class="toggle-icon">
                                    <span class="plus"></span>
                                    <span class="minus"></span>
                                </div>
                                <p>言語聴覚士（正社員）</p>
                            </div>
                        </div>
                        <div class="wp-block-group answer is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <figure class="wp-block-table">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>募集内容</td>
                                                <td>言語聴覚士（正社員）</td>
                                            </tr>
                                            <tr>
                                                <td>仕事内容</td>
                                                <td>個別支援計画・モニタリング・企画作成・送迎・児童指導員業務全般</td>
                                            </tr>
                                            <tr>
                                                <td>診療科目<br>サービス形態</td>
                                                <td>放課後等デイサービス・児童発達支援</td>
                                            </tr>
                                            <tr>
                                                <td>給与</td>
                                                <td>【正職員】月給225,000円～250,000円</td>
                                            </tr>
                                            <tr>
                                                <td>給与の備考</td>
                                                <td>基本給：180,000円<br>資格手当（言語聴覚士）: 15,000円<br>実務手当: 15,000円<br>処遇改善手当：20,000円<br>ベースアップ加算手当：10,000円<br>残業手当</td>
                                            </tr>
                                            <tr>
                                                <td>待遇</td>
                                                <td>社会保険完備・ボーナス、賞与有・交通費支給</td>
                                            </tr>
                                            <tr>
                                                <td>勤務時間</td>
                                                <td>10：00～19：00（休憩60分）　勤務時間は相談可<br>9：30～18：30（休憩60分）　勤務時間は相談可<br>残業ほぼ無し</td>
                                            </tr>
                                            <tr>
                                                <td>休日</td>
                                                <td>週休2日<br>日曜・その他１日</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="wp-block-group qa-wrap is-layout-constrained">
                    <div class="wp-block-group__inner-container">
                        <div class="wp-block-group question is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <div class="toggle-icon">
                                    <span class="plus"></span>
                                    <span class="minus"></span>
                                </div>
                                <p>心理指導担当職員（正社員）</p>
                            </div>
                        </div>
                        <div class="wp-block-group answer is-layout-constrained">
                            <div class="wp-block-group__inner-container">
                                <figure class="wp-block-table">
                                    <table>
                                        <tbody>
                                            <tr>
                                                <td>募集内容</td>
                                                <td>心理指導担当職員（正社員）</td>
                                            </tr>
                                            <tr>
                                                <td>仕事内容</td>
                                                <td>個別支援計画・モニタリング・企画作成・送迎・児童指導員業務全般</td>
                                            </tr>
                                            <tr>
                                                <td>診療科目<br>サービス形態</td>
                                                <td>放課後等デイサービス・児童発達支援</td>
                                            </tr>
                                            <tr>
                                                <td>給与</td>
                                                <td>【正職員】月給225,000円～250,000円</td>
                                            </tr>
                                            <tr>
                                                <td>給与の備考</td>
                                                <td>基本給：180,000円<br>資格手当（心理指導担当職員）: 15,000円<br>実務手当: 15,000円<br>処遇改善手当：20,000円<br>ベースアップ加算手当：10,000円<br>残業手当</td>
                                            </tr>
                                            <tr>
                                                <td>待遇</td>
                                                <td>社会保険完備・ボーナス、賞与有・交通費支給</td>
                                            </tr>
                                            <tr>
                                                <td>勤務時間</td>
                                                <td>10：00～19：00（休憩60分）　勤務時間は相談可<br>9：30～18：30（休憩60分）　勤務時間は相談可<br>残業ほぼ無し</td>
                                            </tr>
                                            <tr>
                                                <td>休日</td>
                                                <td>週休2日<br>日曜・その他１日</td>
                                            </tr>
                                        </tbody>
                                    </table>
                                </figure>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- /contents -->
</div>
<?php get_footer(); ?>