<?php
/*
Template Name: ご利用案内
*/
?>
<?php get_header(); ?>
<div class="page-container page-about page-templates">
<!-- page-head -->
<?php get_template_part('template-parts/page-head'); ?>
<!-- /page-head -->

<!-- contents -->
    <div class="post inner">
        <h2 class="wp-block-heading">ご利用内容</h2>
        <h3 class="wp-block-heading about-title"><span class="font-medium font-normal">児童を対象とした</span>「放課後等デイサービス」</h3>
        <div class="wp-block-columns inner bg-white p40 is-layout-flex wp-container-6">
            <div class="wp-block-column is-layout-flow" style="flex-basis:60%">
                <p class="title-or about-time">時間</p>
                <p class="about-time">【平日】学校終了後～18：30</p>
                <p class="about-time">【休日】10：30～18：30</p>
            </div>
            <div class="wp-block-column is-layout-flow" style="flex-basis:40%">
                <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/about02.png" alt="" /></figure>
            </div>
        </div>
        <p class="tac tdl font-bold mt50">１日の利用人数は、10人です。</p>
        <p class="tac font-medium">※保護者様のお仕事、用事を考慮して対応させていただきます。</p>
        <div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
        <p class="tac tdl font-bold">放課後等デイサービスでは送迎をしています。</p>
        <p class="tac font-medium">※出来る限り対応させて頂きますが、場合によっては保護者様に相談させていただくこともございます。</p>
        <h2 class="wp-block-heading">ご利用料金</h2>
        <div class="wp-block-group inner bg-white p40 is-layout-constrained">
            <div class="wp-block-group__inner-container">
                <h3 class="wp-block-heading about-titleh3">負担上限月額</h3>
                <p class="tac font-medium">ひと月に複数回ご利用の場合は世帯収入によってお支払いいただく上限額が設定されます。<br>下記は負担上限月額の表です。</p>
                <p class="tac font-medium fs14">※市町村によって特例措置もありますので詳しくはお住まいの役所へご確認ください。</p>
                <figure class="wp-block-table inner-sh about-table">
                    <table style="width: 100%; height: 115px;">
                        <tbody>
                            <tr style="height: 23px;">
                                <th style="height: 23px;">世帯の収入状況</th>
                                <th style="height: 23px;">ご負担額</th>
                            </tr>
                            <tr style="height: 23px;">
                                <td style="height: 23px;">生活保護受給世帯</td>
                                <td style="height: 46px;" rowspan="2"><span class="big-num font-bold">0</span>円／月</td>
                            </tr>
                            <tr style="height: 23px;">
                                <td style="height: 23px;">税非課税世帯</td>
                            </tr>
                            <tr style="height: 23px;">
                                <td style="height: 23px;">税非課税世帯（約900万以下）</td>
                                <td style="height: 23px;">4,600円／月</td>
                            </tr>
                            <tr style="height: 23px;">
                                <td style="height: 23px;">世帯所得（約900万以上）</td>
                                <td style="height: 23px;">37,200円／月</td>
                            </tr>
                        </tbody>
                    </table>
                </figure>
                <div style="height:40px" aria-hidden="true" class="wp-block-spacer"></div>
                <h3 class="wp-block-heading about-titleh3">ご利用料金の目安</h3>
                <p class="tac font-medium">1回当たりの利用料は1,100円前後になります。<br>放課後等デイサービスの利用料金は、<br>1割を自費でお支払いいただき、9割は都道府県・市町村が費用を負担しています。</p>
                <div class="wp-block-image">
                    <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/price-graph.png" alt="" /></figure>
                </div>
            </div>
        </div>
        <h2 class="wp-block-heading">ご利用の流れ</h2>
        <div class="wp-block-group inner step-block is-layout-constrained">
            <div class="wp-block-group__inner-container">
                <h3 class="wp-block-heading step-title"><span>STEP1</span>　お問い合わせ</h3>
                <p class="tac font-medium">まずはお問い合わせフォームよりお問い合わせください。<br>電話でも受け付けております。</p>
            </div>
        </div>
        <div class="wp-block-group inner step-block is-layout-constrained">
            <div class="wp-block-group__inner-container">
                <h3 class="wp-block-heading step-title"><span>STEP2</span>　ご相談・ご面談</h3>
                <p class="tac font-medium">気になることやお悩み事をお聞かせください。<br>見学も受け付けております。</p>
            </div>
        </div>
        <div class="wp-block-group inner step-block is-layout-constrained">
            <div class="wp-block-group__inner-container">
                <h3 class="wp-block-heading step-title"><span>STEP3</span>　お申し込み</h3>
                <p class="tac font-medium">具体的なご利用につきましてしっかりとご説明させていただきます。</p>
            </div>
        </div>
        <div class="wp-block-group inner bg-white p40 bg40 is-layout-constrained">
            <div class="wp-block-group__inner-container">
                <h3 class="wp-block-heading step-title"><span>STEP4</span>　ご利用開始</h3>
                <p class="tac font-medium">いよいよご利用開始です。ウィズ春日井柏原での活動を楽しくゆっくりと始めていきましょう！</p>
            </div>
        </div>
        <h2 class="wp-block-heading">受給者証</h2>
        <div class="wp-block-group inner bg-white p40 is-layout-constrained">
            <div class="wp-block-group__inner-container">
                <h3 class="wp-block-heading about-titleh3">受給者証とは</h3>
                <p class="tac font-medium">正式名称を障害福祉サービス受給者証といい、児童福祉法に基づいて運営している事業所の福祉サービスを受けるために必要なものです。医師による意見書と診断書、療育手帳を自治体の福祉窓口に持参すると申請ができます。<br>まずはご相談ください。</p>
                <p class="tac font-medium fs14">ご相談はこちらまで</p>
                <div class="wp-block-image">
                    <figure class="aligncenter size-full"><a href="https://happy-house-with.com/consultation-support-with/" target="_blank" rel="noreferrer noopener"><img decoding="async" loading="lazy" width="482" height="163" src="https://happy-house-with.com/day-survice-with/wp-content/uploads/2023/04/top-banner-ss.png.png" alt="" class="wp-image-264" srcset="https://happy-house-with.com/day-survice-with/wp-content/uploads/2023/04/top-banner-ss.png.png 482w, https://happy-house-with.com/day-survice-with/wp-content/uploads/2023/04/top-banner-ss.png-300x101.png 300w" sizes="(max-width: 482px) 100vw, 482px" /></a></figure>
                </div>
            </div>
        </div>
    </div>
<!-- /contents -->
</div>
<?php get_footer(); ?>