<?php

add_action( 'add_meta_boxes', 'my_custom_field' );
function my_custom_field() {
    add_meta_box(
        'my_custom_field_id', // ID
        'My Custom Field', // 表示タイトル
        'my_custom_field_callback', // コールバック関数
        'post', // 投稿タイプ
        'normal', // 表示位置
        'high' // 優先度
    );
}
// add_action('after_setup_theme', 'my_setup');


// CSSとJavaScriptの読み込み ----------------------------------------------------------
function my_script_init()
{
    wp_enqueue_style(
        'fontawesome',
        'https://use.fontawesome.com/releases/v5.15.4/css/all.css',
        [],
        '5.13.0',
        'all'
    );
    wp_enqueue_style(
        'reset',
        get_template_directory_uri() . '/assets/css/reset.css',
        [],
        '1.0.0',
        'all'
    );
    wp_enqueue_style(
        'my',
        get_template_directory_uri() . '/assets/css/style.css',
        [],
        '1.0.0',
        'all'
    );
    wp_enqueue_script(
        'my',
        get_template_directory_uri() . '/assets/js/script.js',
        ['jquery'],
        '1.0.0',
        true
    );
}
add_action('wp_enqueue_scripts', 'my_script_init');


// メニューの登録 --------------------------------------------------------------------
function my_menu_init()
{
    register_nav_menus([
        'global' => 'ヘッダーメニュー',
        'drawer' => 'ドロワーメニュー',
        'footer' => 'フッターメニュー',
    ]);
}
add_action('init', 'my_menu_init');

function my_custom_field_callback( $post ) {
    $value = get_post_meta( $post->ID, 'group_63e6956a35e48', true );
    echo '<label for="my_custom_field">My Custom Field: </label>';
    echo '<input type="text" id="my_custom_field" name="my_custom_field" value="' . esc_attr( $value ) . '" style="width:100%;" />';
}

add_action( 'save_post', 'my_custom_field_save' );
function my_custom_field_save( $post_id ) {
    if ( isset( $_POST['my_custom_field'] ) ) {
        update_post_meta( $post_id, 'group_63e6956a35e48', $_POST['my_custom_field'] );
    }
}

function show_one_page_custom_field_on_front_page() {
    $page_id = 42; // 固定ページのpost ID
    $page = get_post($page_id);
    if ($page) {
        $custom_field_key = 'group_63e6956a35e48'; // カスタムフィールドのキー
        $custom_field_value = get_post_meta($page_id, $custom_field_key, true);
        if ($custom_field_value) {
            echo $custom_field_value;
        }
    }
}

//記事一覧
function post_has_archive( $args, $post_type ) {
    if ( 'post' == $post_type ) {
        $args['rewrite'] = true;
        $args['has_archive'] = 'news'; //任意のスラッグ名
    }
    return $args;
}
add_filter( 'register_post_type_args', 'post_has_archive', 10, 2 );

?>