<!DOCTYPE html>
<html lang="ja">

<head>
    <meta charset="UTF-8">
    <!-- Google tag (gtag.js) -->
    <!-- <script async src="https://www.googletagmanager.com/gtag/js?id=G-LPZ5226EL5"></script>
    <script>
    window.dataLayer = window.dataLayer || [];
    function gtag(){dataLayer.push(arguments);}
    gtag('js', new Date());

    gtag('config', 'G-LPZ5226EL5');
    </script> -->
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <meta name="description" content="<?php bloginfo('description');?>">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="format-detection" content="telephone=no">
    <title>
    <?php if(is_front_page()):?>
            <?php bloginfo();?>|<?php bloginfo('description');?>
        <?php else:?>
            <?php the_title();?>|<?php bloginfo();?>
        <?php endif;?>
    </title>
    <link rel="icon" href="<?php echo get_template_directory_uri(); ?>/assets/img/favicon.ico">
    <link rel="apple-touch-icon" sizes="180x180" href="<?php echo get_template_directory_uri(); ?>/assets/img/apple-touch-icon.png">
    <?php wp_head(); ?>
</head>

<body <?php body_class();?>>
    <header>
        <div class="header-wrap">
            <?php if(is_front_page() || ( is_404())):?>
            <h1 class="site-title logo">
            <a href="<?php echo home_url(); ?>">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/img/logo.png" alt="放課後等デイサービス ウィズ">
            </a>
            </h1>
            <?php else:?>
            <p class="site-title logo">
            <a href="<?php echo home_url(); ?>">
            <img src="<?php echo get_template_directory_uri(); ?>/assets/img/logo.png" alt="放課後等デイサービス ウィズ">
            </a>
            </p>
            <?php endif;?>
            <div class="header-right">
                <div class="tel">
                    <div class="tel-number">
                    <a href="tel:0568374540">
                    <img class="tel-number-icon" src="<?php echo get_template_directory_uri(); ?>/assets/img/tel_icon.svg" alt="電話">
                        <span>0568-41-9887</span></a>
                    </div>
                    <p class="reception-time">受付時間 / 平日9:30～19:00</p>
                </div>
                <a href="<?php echo home_url(); ?>/contact" class="mail-bnr">
                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/mail_icon.svg" alt="メール">
                    <p class="mail-bnr-txt">お問い合わせ</p>
                </a>
            </div>
            <div class="header-right2">
                <a href="<?php echo home_url(); ?>/contact" class="sp-top-mail-bnr"><img src="<?php echo get_template_directory_uri(); ?>/assets/img/mail_icon.svg" alt="メール" width="30"></a>
                <input id="drawer-input" class="drawer-hidden" type="checkbox">
                <label for="drawer-input" class="drawer-open"><span></span></label>
                
                <section class="hamburger">
                    <div class="btn-trigger" id="btn17">
                        <span></span>
                        <span></span>
                        <span></span>
                    </div>
                        <nav id="g-nav">
                            <div id="g-nav-list"><!--ナビの数が増えた場合縦スクロールするためのdiv※不要なら削除-->
                                <ul class="menu sp-menu">
                                    <li><a href="<?php echo home_url(); ?>/support"><p>支援方針</p></a></li> 
                                    <li><a href="<?php echo home_url(); ?>/about"><p>ご利用案内</p></a></li> 
                                    <li><a href="<?php echo home_url(); ?>/flow"><p>1日の流れ</p></a></li> 
                                    <li><a href="<?php echo home_url(); ?>/cotegory/news"><p>ニュース</p></a></li> 
                                    <li><a href="<?php echo home_url(); ?>/qa"><p>Q&amp;A</p></a></li> 
                                    <li><a href="<?php echo home_url(); ?>/institution"><p>施設概要</p></a></li> 
                                </ul>
                                <div class="hamburger-contact-btn">
                                    <a href="<?php echo home_url(); ?>/contact" class="sp-mail-bnr">
                                    <img src="<?php echo get_template_directory_uri(); ?>/assets/img/mail_icon.svg" alt="メール">
                                    <p class="mail-bnr-txt">お問い合わせ</p>
                                    </a>
                                </div>
                            </div>
                        </nav>
                </section>
            </div>
        </div>
    </header>
