<?php
/*
Template Name: 1日の流れ
*/
?>
<?php get_header(); ?>
<div class="page-container page-flow page-templates">
    <!-- page-head -->
    <?php get_template_part('template-parts/page-head'); ?>
    <!-- /page-head -->

    <!-- contents -->
    <div class="post inner">
        <h2 class="wp-block-heading">得意や苦手に合わせた<br>個別のプログラムを作成！</h2>
        <p class="inner-sh mb40 font-medium">ご利用にあたってまずは保護者様としっかりとご相談し、一人ひとりの得意や苦手に合わせた個別のプログラムを作成したうえで、療育を行っております。厳しい指導ではないので無理なくそれぞれのペースで成長を目指していただけます。</p>
        <div class="tabs">
            <input id="day-general" type="radio" name="tab_item" checked>
            <label class="tab_item" for="day-general">登校日</label>
            <input id="day-holiday" type="radio" name="tab_item">
            <label class="tab_item" for="day-holiday">休校日</label>
            <section id="day-general_content" class="wp-block-group tab_content is-layout-constrained">
                <div class="wp-block-group__inner-container">
                    <h3 class="wp-block-heading step-title">登校日の場合</h3>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">お迎え</h4>
                            <div class="wp-block-group inner step-block is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage01.png" alt="" width="260"/></figure>
                                    </div>
                                    <p class="tac">スタッフがご自宅、学校までご都合に合わせてお迎えに上がります。お友達やスタッフとしっかり挨拶。<br>何事も挨拶から、というウィズの方針です。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">個別プログラム開始</h4>
                            <div class="wp-block-group inner step-block is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage02.png" alt="" width="260"/></figure>
                                    </div>
                                    <p class="tac">宿題や学習プログラム・生活プログラムなど、学校終了時に「訓練」ではヘトヘトになってしまいますので、遊びやコミュニケーションを通して押し付けない学習を行います。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">ティータイム</h4>
                            <div class="wp-block-group inner step-block is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage05.png" alt="" width="260"/></figure>
                                    </div>
                                    <p class="tac">みんなそろって団らんタイム。ティータイムは社会性を磨く大事な時間でもあります。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">集団・グループプログラム開始</h4>
                            <div class="wp-block-group inner step-block is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage04.png" alt="" width="260"/></figure>
                                    </div>
                                    <p class="tac">
                                    個人または集団でプログラムに取り組みます。<br>個々のすきなことを追求したり、みんなで話し合って調理・外出などの様々なイベントを企画運営したり。<br>プログラムを通して、何事にも自発的に取り組む力を身に着けていきます。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">室内の清掃・整理、洗濯</h4>
                            <div class="wp-block-group inner step-block is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage06.png" alt="" width="360"/></figure>
                                    </div>
                                    <p class="tac">自宅へのお送りの前に、室内の清掃や洗濯などを行います。<br>普段使う場所を綺麗に保つことで、心の安定をはかるだけでなく、<br>他者の役に立つ実感も得られるようサポートしています。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">自宅へお送り</h4>
                            <div class="wp-block-group inner bg-white p40 mb40 is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage07.png" alt="" width="260"/></figure>
                                    </div>
                                    <p class="tac">到着時に、スタッフがご家族へウィズ春日井柏原でのお子様のご様子を報告いたします。<br>細かな事でもご家族からのご意見をうかがい、情報交換をする場でもございます。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <section id="day-holiday_content" class="wp-block-group tab_content is-layout-constrained">
                <div class="wp-block-group__inner-container">
                    <h3 class="wp-block-heading step-title">休校日の場合</h3>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">お迎え</h4>
                            <div class="wp-block-group inner step-block is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage01.png" alt="" width="260"/></figure>
                                    </div>
                                    <p class="tac">スタッフがご自宅、学校までご都合に合わせてお迎えに上がります。お友達やスタッフとしっかり挨拶。<br>何事も挨拶から、というウィズの方針です。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">個別プログラム開始</h4>
                            <div class="wp-block-group inner step-block is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage02.png" alt="" width="260"/></figure>
                                    </div>
                                    <p class="tac">宿題や学習プログラム・生活プログラムなど、遊びやコミュニケーションを通して押し付けない学習を行います。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">お昼ごはん</h4>
                            <div class="wp-block-group inner step-block is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage03.png" alt="" width="260"/></figure>
                                    </div>
                                    <p class="tac">みんなそろっておいしく楽しくお昼ご飯を食べます。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">集団・グループプログラム開始</h4>
                            <div class="wp-block-group inner step-block is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage04.png" alt="" width="260"/></figure>
                                    </div>
                                    <p class="tac">
                                    個人または集団でプログラムに取り組みます。<br>個々のすきなことを追求したり、みんなで話し合って調理・外出などの様々なイベントを企画運営したり。<br>プログラムを通して、何事にも自発的に取り組む力を身に着けていきます。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">ティータイム</h4>
                            <div class="wp-block-group inner step-block is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage05.png" alt="" width="260"/></figure>
                                    </div>
                                    <p class="tac">みんなそろって団らんタイム。イベント時には、一緒に協力して「クッキー」や「ホットケーキ」を作ったり準備をしたりして楽しくおやつを食べます。ティータイムは社会性を磨く大事な時間でもあります。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">集団・グループプログラム再開</h4>
                            <div class="wp-block-group inner step-block is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage04.png" alt="" width="260"/></figure>
                                    </div>
                                    <p class="tac">午前中のプログラムの続きや<br>新しいプログラムを通じてお友達と交流をします。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">室内の清掃・整理、洗濯</h4>
                            <div class="wp-block-group inner step-block is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage06.png" alt="" width="360"/></figure>
                                    </div>
                                    <p class="tac">自宅へのお送りの前に、室内の清掃や洗濯などを行います。<br>普段使う場所を綺麗に保つことで、心の安定をはかるだけでなく、<br>他者の役に立つ実感も得られるようサポートしています。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="wp-block-group is-layout-constrained">
                        <div class="wp-block-group__inner-container">
                            <h4 class="wp-block-heading about-title">自宅へお送り</h4>
                            <div class="wp-block-group inner bg-white p40 mb40 is-layout-constrained">
                                <div class="wp-block-group__inner-container">
                                    <div class="wp-block-image">
                                        <figure class="aligncenter size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/dayimage07.png" alt="" width="260"/></figure>
                                    </div>
                                    <p class="tac">到着時に、スタッフがご家族へウィズ春日井柏原でのお子様のご様子を報告いたします。<br>細かな事でもご家族からのご意見をうかがい、情報交換をする場でもございます。</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
        </div>
        <h2 class="wp-block-heading">年間スケジュール</h2>
        <div class="wp-block-group inner bg-white schedule-table-img is-layout-constrained">
            <div class="wp-block-group__inner-container">
                <table class="schedule-table">
                    <tbody>
                        <tr style="height: 23px;">
                            <td style="height: 23px;">4月</td>
                            <td style="height: 23px;">花見　　親子参加行事（ハイキングなど）</td>
                        </tr>
                        <tr style="height: 23px;">
                            <td style="height: 23px;">5月</td>
                            <td style="height: 23px;">こどもの日イベント・避難訓練</td>
                        </tr>
                        <tr style="height: 23px;">
                            <td style="height: 23px;">6月</td>
                            <td style="height: 23px;">遠足</td>
                        </tr>
                        <tr style="height: 23px;">
                            <td style="height: 23px;">7月</td>
                            <td style="height: 23px;">七夕・避難訓練</td>
                        </tr>
                        <tr style="height: 23px;">
                            <td style="height: 23px;">8月</td>
                            <td style="height: 23px;">おばけ屋敷</td>
                        </tr>
                        <tr style="height: 23px;">
                            <td style="height: 23px;">9月</td>
                            <td style="height: 23px;">運動会・避難訓練</td>
                        </tr>
                        <tr style="height: 23px;">
                            <td style="height: 23px;">10月</td>
                            <td style="height: 23px;">ハロウィンパーティ ミニキャンプ</td>
                        </tr>
                        <tr style="height: 23px;">
                            <td style="height: 23px;">11月</td>
                            <td style="height: 23px;">職業体験　　避難訓練</td>
                        </tr>
                        <tr style="height: 23px;">
                            <td style="height: 23px;">12月</td>
                            <td style="height: 23px;">クリスマスパーティ</td>
                        </tr>
                        <tr style="height: 23px;">
                            <td style="height: 23px;">1月</td>
                            <td style="height: 23px;">年明けイベント</td>
                        </tr>
                        <tr style="height: 19px;">
                            <td style="height: 19px;">2月</td>
                            <td style="height: 19px;">バレンタイン・避難訓練</td>
                        </tr>
                        <tr style="height: 23px;">
                            <td style="height: 23px;">3月</td>
                            <td style="height: 23px;">ホワイトデー・ウィズ卒業式</td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
        <h2 class="wp-block-heading">保護者の方へ</h2>
        <div class="wp-block-group bg-white p40 tac is-layout-constrained">
            <div class="wp-block-group__inner-container">
                <p>ウィズ春日井柏原では、<br>発達障がい（自閉症スペクトラム、ADHD、学習障がい）など、それぞれサポートする内容が異なります。<br>また、お子様の性格や趣味・嗜好も異なりますので、ひとりひとりに合わせた療育が必要です。</p>
                <p>しかし、時間と住む環境はみんな同じです。<br>ウィズ春日井柏原で過ごす時間はお子様の人生にとっては微々たる時間でしかありません。<br>これから多くを過ごすであろう社会に少しでも多く接していただきたいと考えています。</p>
                <p>そのため、社会見学や公園、動物園などへの公共交通機関を使ったお出かけ、買物レクリエーションなど外部から受ける刺激も大切にしています。<br>お子様が過ごす環境はお子様の成長と共に変化していくからです。<br>そんな環境の変化を楽しみ幅広い大人へと成長していただきたいと考えています。</p>
            </div>
        </div>
        <h2 class="wp-block-heading">相談支援専門員の方へ</h2>
        <div class="wp-block-group bg-white p40 tac is-layout-constrained">
            <div class="wp-block-group__inner-container">
                <p>お子様が主役となって自発的に活動ができるようにご支援させていただきます。</p><br>
                <p>プログラムを用意しておりますが、無理に強いるという事はしません。<br>そのため、強制的に「みんなで一緒に体操」や「みんなで歌を歌う」ことは行いません。<br>数あるプログラムの中から、自己決定や自己選択を促し、自発的にプログラムに取り組めるよう支援いたします。</p><br>
                <p class="font-bold">・他事業所で訓練やプログラムを強制されて馴染めない<br>・まずはご利用者様の興味のある内容から徐々に取り組みたい<br>・自分の居場所を見つけ、社会参加を促していきたい</p>　　　　<br>
                <p>このようなお悩みをお持ちのご利用者様がおられましたらお気軽にお問い合わせください。</p>
            </div>
        </div>
    </div>
<!-- /contents -->
</div>
<?php get_footer(); ?>