<?php
/*
Template Name: 支援方針
*/
?>
<?php get_header(); ?>
<div class="page-container page-support page-templates">
    <!-- page-head -->
    <?php get_template_part('template-parts/page-head'); ?>
    <!-- /page-head -->

    <!-- contents -->
    <div class="post inner">
        <h2 class="wp-block-heading">ウィズ春日井柏原の支援方針</h2>
        <div class="wp-block-columns is-layout-flex wp-container-4 friendship-block">
            <div class="wp-block-column is-layout-flow">
                <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/friendship01.png" alt="" class="friendship-pic" /></figure>
            </div>
            <div class="wp-block-column is-layout-flow">
                <h3 class="wp-block-heading friendship-title">仲間活動を中心とした活動の取り組み</h3>
                <div class="wp-block-group friendship-box is-layout-constrained">
                    <div class="wp-block-group__inner-container">
                        <p>学校での集団生活で必要なスキル、ルールやマナーを守る力やコミュニケーション力などを育んでいける様々な仲間活動を行っています。</p>
                        <p>友達の誘い方、遊び方、仲直りの仕方など、仲間活動の中で経験を積み重ね、学んでいきます。</p>
                    </div>
                </div>
            </div>
        </div>
        <div class="wp-block-columns is-layout-flex wp-container-8 friendship-block">
            <div class="wp-block-column order2 is-layout-flow">
                <h3 class="wp-block-heading friendship-title">個別の課題への取り組み</h3>
                <div class="wp-block-group friendship-box is-layout-constrained">
                    <div class="wp-block-group__inner-container">
                    <p>自分のやりたいことや興味のあることへ自発的に向き合う力をはぐくみます。 </p>
                        <p>好きなことを追求するなかで、課題の解決や目標へのプロセス策定など、自分で考えて行動する姿勢が身に着けられます。 </p>
                    </div>
                </div>
            </div>
            <div class="wp-block-column order1 is-layout-flow">
                <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/friendship02.jpg" alt="" class="friendship-pic"/></figure>
            </div>
        </div>
        <div class="wp-block-columns is-layout-flex wp-container-12 friendship-block">
            <div class="wp-block-column is-layout-flow">
                <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/friendship03.png" alt="" class="friendship-pic"/></figure>
            </div>
            <div class="wp-block-column is-layout-flow">
                <h3 class="wp-block-heading friendship-title">共に取り組む</h3>
                <div class="wp-block-group friendship-box is-layout-constrained">
                    <div class="wp-block-group__inner-container">
                        <p class="bg-white">お子様、保護者様、ウィズ春日井柏原のスタッフで一緒に取り組みます。</p>
                        <p class="bg-white">お子様の困りごとは、いつでもご相談ください。保護者様と一緒にスタッフ全員で取り組んでいきます。</p>
                    </div>
                </div>
            </div>
        </div>
        <h2 class="wp-block-heading">AIDMAの原理を応用した個別対応</h2>
        <p class="font-bold">スタッフが保護者様、お子様から「得意なことや好きなこと、苦手なこと」を聞き取りし、お子様が興味を持ってもらえそうなことに誘います。お子様が気になり始めたら、活動スタート！</p>
        <section class="wp-block-group aidma-sec is-layout-constrained">
            <div class="wp-block-group__inner-container">
                <div class="wp-block-columns aidma-block is-layout-flex wp-container-15">
                    <div class="wp-block-column is-layout-flow" style="flex-basis:33.33%">
                        <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/aidma_a.jpg" alt="" /></figure>
                    </div>
                    <div class="wp-block-column aidma-txt is-layout-flow" style="flex-basis:66.66%">
                        <p class="aidma-title">Attention<span>注意</span></p>
                        <p class="font-bold">自己防衛の欲求が強いお子様には、カードやボードゲーム等のツールも用います。<br>言語やダイレクトコミュニケーションだけでなく非言語、間接的なアプローチにより、お子様に無理強いをすることなく溶け込んでいただけます。</p>
                    </div>
                </div>
                <div class="wp-block-columns aidma-block is-layout-flex wp-container-18">
                    <div class="wp-block-column is-layout-flow" style="flex-basis:33.33%">
                        <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/aidma_i.jpg" alt="" /></figure>
                    </div>
                    <div class="wp-block-column aidma-txt is-layout-flow" style="flex-basis:66.66%">
                        <p class="aidma-title">Interest<span>興味・関心</span></p>
                        <p class="font-bold">特定の対象物に強くひかれているお子様もいらっしゃいます。<br>まずスタッフはその対象物を探します。<br>対象物を共有できる状況をつくり、たくさん会話して出来たことを具体的に褒めてお子様に自信をつけていただきます。</p>
                    </div>
                </div>
                <div class="wp-block-columns aidma-block is-layout-flex wp-container-21">
                    <div class="wp-block-column is-layout-flow" style="flex-basis:33.33%">
                        <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/aidma_d.jpg" alt="" /></figure>
                    </div>
                    <div class="wp-block-column aidma-txt is-layout-flow" style="flex-basis:66.66%">
                        <p class="aidma-title">Desire<span>欲求</span></p>
                        <p class="font-bold">共有ができると更に一緒に共有したくなり、特定なものやこだわりも出てくるでしょう。<br>職員は他のお友達も誘い、活動を通して触れ合う機会を設けます。</p>
                    </div>
                </div>
                <div class="wp-block-columns aidma-block is-layout-flex wp-container-24">
                    <div class="wp-block-column is-layout-flow" style="flex-basis:33.33%">
                        <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/aidma_m.jpg" alt="" /></figure>
                    </div>
                    <div class="wp-block-column aidma-txt is-layout-flow" style="flex-basis:66.66%">
                        <p class="aidma-title">Memory<span>記憶</span></p>
                        <p class="font-bold">利用を通して施設での環境に少しずつ慣れることで、感情も安定します。<br>「また、一緒に○○したい！」と思うようになれば、自発的にスタッフやお友達を誘うようにお子様へ言葉をかけます。</p>
                    </div>
                </div>
                <div class="wp-block-columns aidma-block is-layout-flex wp-container-27">
                    <div class="wp-block-column is-layout-flow" style="flex-basis:33.33%">
                        <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/aidma_a2.jpg" alt="" /></figure>
                    </div>
                    <div class="wp-block-column aidma-txt is-layout-flow" style="flex-basis:66.66%">
                        <p class="aidma-title">Action<span>行動</span></p>
                        <p class="font-bold">新たなルールや別の遊びを提案し、お子様とたくさんお話しすることで、お子様のやりたいことを職員、お友達に教えていただきます。<br>繰り返すことで、その環境に慣れて安定していきますので、次のステージを目指すことが出来ます。</p>
                    </div>
                </div>
            </div>
        </section>
        <h2 class="wp-block-heading">支援する３つのスキル</h2>
        <div class="wp-block-columns is-layout-flex wp-container-32">
            <div class="wp-block-column is-layout-flow">
                <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/skill01.png" alt="" /></figure>
                <h3 class="wp-block-heading skill-title">学習スキル</h3>
                <p class="tac font-bold">宿題のサポート以外にも、<br>個々の興味やレベルに応じた<br> 学習をすすめています。</p>
            </div>
            <div class="wp-block-column is-layout-flow">
                <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/skill02.png" alt="" /></figure>
                <h3 class="wp-block-heading skill-title">生活スキル</h3>
                <p class="tac font-bold">月１回の調理や外出・イベントなど、<br> 企画から運営・実行まで、<br> みんなで話し合ってつくりあげていきます。</p>
            </div>
            <div class="wp-block-column is-layout-flow">
                <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/skill03.png" alt="" /></figure>
                <h3 class="wp-block-heading skill-title">社会的スキル</h3>
                <p class="tac font-bold">他人と共存することができるように<br> 複数人でコミュニケーションを図ります。<br> </p>
            </div>
        </div>
        <h2 class="wp-block-heading">施設の様子</h2>
        <figure class="wp-block-gallery has-nested-images columns-default is-cropped institution-gallery wp-block-gallery-33 is-layout-flex">
            <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/exterior01.jpg" alt="" /></figure>
            <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/activity01.jpg" alt="" /></figure>
            <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/kitchen01.jpg" alt="" /></figure>
        </figure>
        <div style="height:20px" aria-hidden="true" class="wp-block-spacer"></div>
        <figure class="wp-block-gallery has-nested-images columns-default is-cropped institution-gallery wp-block-gallery-34 is-layout-flex">
            <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/study01.jpg" alt="" /></figure>
            <figure class="wp-block-image size-large"><img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/consult01.jpg" alt="" /></figure>
            <figure class="wp-block-image size-large"></figure>
        </figure>
        <div style="height:80px" aria-hidden="true" class="wp-block-spacer"></div>
        <div class="flex justify-between inner-sh">
            <div class="ye-button align">
                <a  href="<?php echo esc_url(home_url('/staff')); ?>">
                    <img decoding="async" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/staff_or.svg" alt="" />
                    <p>スタッフ紹介</p>
                </a>
            </div>
            <div class="ye-button align">
                <a  href="<?php echo esc_url(home_url('/institution')); ?>">
                    <img decoding="async" style="padding: 4px 0;" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/img/common/home_or.svg" alt="" />
                    <p>施設情報</p>
                </a>
            </div>
        </div>
    </div>
    <!-- /contents -->
</div>
<?php get_footer(); ?>