<?php
/*
Template Name: 相談支援お問い合わせフォーム（page-support-contact.php）
*/
?>

<!DOCTYPE html>
<html lang="ja">
<head>
    <meta charset="utf-8">
    <meta name="description" content="">
    <title>お問い合わせフォーム 相談支援ウィズ</title>
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/support-contact/assets/css/reset.css">
    <link rel="stylesheet" href="<?php echo get_template_directory_uri(); ?>/support-contact/assets/css/style.css">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Noto+Sans+JP:wght@400;700&display=swap" rel="stylesheet">
    <script src="https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <?php wp_head(); ?>
</head>
<body class="consultation-support-with">
    <!-- Header -->
<header class="header">
    <h1 class="site-title"><a href="index.html">相談支援ウィズ</a></h1>
</header>
<!-- /Header -->
<!--contact-block -->
<section class="contact-block inner m80a bg-white">
    <div class="contact-block-inner">
        <h2 class="ss-title">お問い合わせフォーム</h2>
        <p class="tac mb40">不安なことや気になったことなど、なんでもお気軽にご相談ください！</p>
        <?php echo do_shortcode('[contact-form-7 id="230" title="相談支援ーお問い合わせ"]'); ?>
        <p class="tac mb40"><a href="<?php echo home_url(); ?>/../consultation-support-with/index.html">相談支援ウィズページに戻る</a></p>
        <p class="grecaptcha-text">このサイトはreCAPTCHAによって保護されており、Googleの<a href="https://policies.google.com/privacy">プライバシーポリシー</a>と<a href="https://policies.google.com/terms">利用規約</a>が適用されます。</p>
    </div>
</section>
<!--/contact--block -->
<!--top-contact-block -->
<section class="top-contact-block m80a">
    <h2 class="ss-contact-title">お気軽にお問い合わせください</h2>
    <div class="top-contact-items inner flex wrap justify-between">
        <div class="top-contact-button">
            <p><a href="tel:0568-29-8306"><span class="span-catch">電話</span>でお問い合わせ<br><span class="span-remarks">受付時間 9:00～18:00</span></a></p>
        </div>
        <div class="top-contact-button">
            <p>
              <a href="<?php echo home_url(); ?>/support-contact">
            <span class="span-catch">
                <!-- メール -->
                お問い合わせフォーム
            </span>
            <!-- でお問い合わせ -->
            <br><span class="span-remarks">24時間受付中</span>
        </a>
        </p>
    </div>
    </div>
</section>
<!--/top-contact-block -->
<!--footer -->
<footer class="pt40">
    <div class="footer-inner inner flex wrap m40a">
            <div class="footer-company">
                <p class="footer-company-title">相談支援ウィズ</p>
                <p>〒486-0844<br>
                愛知県春日井市鳥居松町8-32-2はとビル305号室</p>
                <p>TEL:0568-29-8306　FAX:0568-29-8307</p>
            </div>
            <div class="footer-bnr-button">
                <a href="<?php echo home_url(); ?>/../index.html">
                    <img src="<?php echo get_template_directory_uri(); ?>/support-contact/assets/img/footer-banner-hh.png" width="464" height="145">
                </a>
            </div>
            <div class="footer-bnr-button">
                <a href="<?php echo home_url(); ?>">
                    <img src="<?php echo get_template_directory_uri(); ?>/support-contact/assets/img/top-banner-hds.png" width="464" height="145">
               </a>
            </div>
    </div>
    <small>© 2022 Happy House inc.</small>
</footer>
<!--footer -->
<script src="./assets/js/script.js"></script>
<?php wp_footer();?>
</body>
</html>